@extends('layouts.admin.master')

@section('admin_main_body')

    <!-- Content -->
    <!-- Start::app-content -->

    <div class="container-fluid">

        <!-- Page Header -->
        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">File Manager</h1>
                <div class="">
                    <nav>
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Parent Folder</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Sub Folders</li>
                        </ol>
                    </nav>
                </div>
            </div>
            <div class="btn-list">
                <button class="btn btn-primary-light btn-wave me-2">
                    <i class="bx bx-crown align-middle"></i> Parent Folder
                </button>
                <button class="btn btn-secondary-light btn-wave me-0">
                    <i class="ri-upload-cloud-line align-middle"></i> Export Report
                </button>
                {{-- <a href="{{ route('admin.view.file.folders') }}" class="btn btn-secondary mb-1" >Back</a> --}}
            </div>
        </div>
    </div>
    <!-- Page Header Close -->

    <!-- Start:: row-1 -->
    <div class="row">

    </div>

    <div class="col-12">
        <div class="card custom-card overflow-hidden">
            <div class="card-body p-0">
                <div class="file-manager-folders">
                    <div class="d-flex p-3 flex-wrap gap-2 align-items-center justify-content-between border-bottom">
                        <div class="flex-fill">
                            <h6 class="fw-medium mb-0">Sub Folders</h6>
                        </div>

                    </div>


                    <div class="card-body">
                        <div class="btn-list">

                            <button type="button" class="btn btn-secondary mb-1" data-bs-toggle="modal"
                                data-bs-target="#formsubfolderfilemodal" data-bs-whatever="@mdo">Upload New File</button>
                        </div>


                        <div class="modal fade" id="formsubfolderfilemodal" tabindex="-1"
                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h6 class="modal-title" id="exampleModalLabel">Upload New File</h6>

                                    </div>
                                    <div class="modal-body">

                                        <form method="post" action="{{ route('admin.upload.files', $sub_folder_id) }}"
                                            enctype="multipart/form-data">

                                            @csrf

                                            @if ($errors->any())
                                                <div class="alert alert-danger">
                                                    <ul>
                                                        @foreach ($errors->all() as $error)
                                                            <li>{{ $error }}</li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            @endif
                                            <div class="mb-3">
                                                <label for="recipient-name" class="col-form-label">File Name:</label>
                                                <input type="file" name="file_name" class="form-control"
                                                    id="recipient-name">
                                            </div>
                                            {{-- <div class="mb-3">
                                                            <label for="message-text"
                                                                class="col-form-label">Message:</label>
                                                            <textarea class="form-control" id="message-text"></textarea>
                                                        </div> --}}

                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary">Save</button>
                                    </div>

                                    </form>
                                </div>
                            </div>
                        </div>





                    </div>





                            <div class="col-xl-12">
                                <div class="card custom-card">
                                    <div class="card-body">
                                        <div class="tab-content">

                    {{-- <div class="d-flex mb-3 align-items-center justify-content-between">
                        <p class="mb-0 fw-medium fs-14">Parent Folder: {{ $sub_folder_id }}</p>
                        <a href="javascript:void(0);" class="fs-12 text-muted fw-medium"> View
                            All<i class="ti ti-arrow-narrow-right ms-1"></i> </a>
                    </div> --}}

  @if ( !$all_files->isEmpty())
                <div class="d-flex mb-3 align-items-center justify-content-between">
                    <p class="mb-0 fw-medium fs-14"> Files in this folder: {{ $sub_folder_id }} </p>
                    <a href="javascript:void(0);" class="fs-12 text-muted fw-medium"> View All<i
                            class="ti ti-arrow-narrow-right ms-1"></i> </a>
                </div>
      @endif

        @if ( $all_files->isEmpty())
                <div class="d-flex mb-3 align-items-center justify-content-between">
                    <p class="mb-0 fw-medium fs-14"> Database File is Empty In Folder: {{ $sub_folder_id }} </p>
                    <a href="javascript:void(0);" class="fs-12 text-muted fw-medium"> View All<i
                            class="ti ti-arrow-narrow-right ms-1"></i> </a>
                </div>
      @endif
    <div class="row">

            <div class="col-xl-12">


     @if ($all_files == null || $all_files->isEmpty())
             <span class="fs-12 text-muted">No Data Found!</span>
        @endif

         @if (!$all_files == null || !$all_files->isEmpty())
                        <div class="table-responsive border border-bottom-0">
                            <table class="table text-nowrap table-hover">

                                <thead>
                                    <tr>
                                        <th scope="col">File Name</th>
                                        <th scope="col">Category</th>
                                        <th scope="col">File Type</th>
                                        <th scope="col">Size</th>
                                        <th scope="col">Date Modified</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>

                                <tbody class="files-list">
                                     @foreach ($all_files as $key => $files)
                                    <tr>

                                            <td>{{ $files->file_name }}</td>
                                            <td>{{ $files->description }}</td>
                                            <td>{{ $files->file_type }}</td>
                                            <td>{{ $files->file_size }}</td>
                                            <td>{{ $files->file_name }}</td>
                                            <td>
                                                <div class="hstack gap-2 fs-15">
                                                    <a href="javascript:void(0);"
                                                        class="btn btn-icon btn-sm btn-info-light"><i
                                                            class="ri-eye-line"></i></a>
                                                    <a href="javascript:void(0);"
                                                        class="btn btn-icon btn-sm btn-danger-light"><i
                                                            class="ri-delete-bin-line"></i></a>
                                                    <a href="javascript:void(0);"
                                                        class="btn btn-icon btn-sm btn-success-light"><i
                                                            class="ri-edit-line"></i></a>
                                                </div>
                                            </td>
                                    </tr>



                                    @endforeach

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="5">
                                            <nav aria-label="Page navigation">
                                                <ul class="pagination justify-content-end mb-0">
                                                    <li class="page-item disabled"><a class="page-link"
                                                            href="javascript:void(0);">Previous</a></li>
                                                    <li class="page-item"><a class="page-link"
                                                            href="javascript:void(0);">1</a></li>
                                                    <li class="page-item"><a class="page-link"
                                                            href="javascript:void(0);">2</a></li>
                                                    <li class="page-item"><a class="page-link"
                                                            href="javascript:void(0);">Next</a></li>
                                                </ul>
                                            </nav>
                                        </td>


                                    </tr>
                                </tfoot>
                            </table>
                        </div>

    @endif

                    </div>




                </div>
            </div>
        </div>
    </div>
    </div>
    </div>
    </div>
    <!-- End:: row-1 -->

    </div>

    <!-- End::app-content -->
@endsection
